<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class Spedizione {
        private $db;
        private $id;
        private $nome;
        private $disponibile;
        private $categoria;
        private $descrizione;
        private $costo;
        private $costoZoneDisagiate;
        private $importoMinimoCarrello;
        private $giorniNecessari;
        private $orarioLimite;
        private $giorniInCuiSiSpedisce;
        private $areaGeografica;
        private $dataCreazione;

        public function __construct($db, $id, $nome="", $disponibile="", $categoria=0, $descrizione="", $giorniNecessari = 0, $orarioLimite='00:00', $giorniInCuiSiSpedisce = "", $costo=0, $costoZoneDisagiate=0, $importoMinimoCarrello=0, $areaGeografica = 0, $dataCreazione="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->disponibile     = $disponibile;
            $this->categoria       = $categoria;
            $this->descrizione     = $descrizione;
            $this->giorniNecessari = $giorniNecessari;
            $this->orarioLimite    = $orarioLimite;
            $this->giorniInCuiSiSpedisce = $giorniInCuiSiSpedisce;
            $this->costo = $costo;
            $this->costoZoneDisagiate = $costoZoneDisagiate;
            $this->importoMinimoCarrello = $importoMinimoCarrello;
            $this->areaGeografica = $areaGeografica;
            $this->dataCreazione = $dataCreazione;
        }

        function crea() {
            $dataCreazione = date("Y-m-d");
            $query = "INSERT INTO `geecEc_metodiSpedizione` (`id`, `nome`, `disponibile`, `categoria`, `descrizione`, `giorniNecessari`, `giorniInCuiSiSpedisce`, `orarioLimite`, `costo`, `costoZoneDisagiate`, `importoMinimoCarrello`, `areaGeografica`,`dataCreazione`) 
                        VALUES (NULL, '$this->nome', '$this->disponibile', '$this->categoria', '$this->descrizione', $this->giorniNecessari, '$this->orarioLimite', '$this->giorniInCuiSiSpedisce', '$this->costo', '$this->costoZoneDisagiate', '$this->importoMinimoCarrello', '$this->areaGeografica', '$dataCreazione');";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function modifica() {
            $query = "UPDATE geecEc_metodiSpedizione SET nome='$this->nome', disponibile ='$this->disponibile', categoria='$this->categoria', descrizione='$this->descrizione', giorniNecessari='$this->giorniNecessari', giorniInCuiSiSpedisce='$this->giorniInCuiSiSpedisce', orarioLimite='$this->orarioLimite', costo='$this->costo', costoZoneDisagiate='$this->costoZoneDisagiate', importoMinimoCarrello='$this->importoMinimoCarrello', areaGeografica='$this->areaGeografica' WHERE id= $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecEc_metodiSpedizione",$this->id);
        }
        
        function caricaDatiDalDatabase() {
            $datiSpedizione           = $this->db->leggiSingolaRiga("geecEc_metodiSpedizione",$this->id);
            $this->nome               = $datiSpedizione["nome"];
            $this->disponibile        = $datiSpedizione["disponibile"];
            $this->categoria          = $datiSpedizione["categoria"];
            $this->descrizione        = $datiSpedizione["descrizione"];
            $this->giorniNecessari    = $datiSpedizione["giorniNecessari"];
            $this->giorniInCuiSiSpedisce = $datiSpedizione["giorniInCuiSiSpedisce"];
            $this->orarioLimite          = $datiSpedizione["orarioLimite"];
            $this->costo                 = $datiSpedizione["costo"];
            $this->costoZoneDisagiate    = $datiSpedizione["costoZoneDisagiate"];
            $this->importoMinimoCarrello = $datiSpedizione["importoMinimoCarrello"];
            $this->areaGeografica        = $datiSpedizione["areaGeografica"];
            $this->dataCreazione         = $datiSpedizione["dataCreazione"];
        }
        
        function aggiungiFasciaDiPrezzo($pesoMinimo,$pesoMassimo,$costo,$costoZoneDisagiate) {
            $query = "INSERT INTO `geecEc_fascePrezzoSpedizione` (`id`, `idSpedizione`, `pesoMinimo`, `pesoMassimo`, `costo`, `costoZoneDisagiate`) 
                        VALUES (NULL, '$this->id', '$pesoMinimo', '$pesoMassimo', '$costo', '$costoZoneDisagiate');";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function modificaFasciaDiPrezzo($id,$pesoMinimo,$pesoMassimo,$costo,$costoZoneDisagiate) {
            $query = "UPDATE `geecEc_fascePrezzoSpedizione` SET pesoMinimo='$pesoMinimo', pesoMassimo='$pesoMassimo', costo='$costo', costoZoneDisagiate='$costoZoneDisagiate' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function stampaFasceDiPrezzo() {
            $query = "SELECT * FROM geecEc_fascePrezzoSpedizione WHERE idSpedizione=$this->id ORDER BY pesoMinimo ASC";
            $ris   = $this->db->eseguiQueryLettura($query);
            
            while($fasciaPrezzo = $ris->fetch_assoc()) {
                $datiFasceDiPrezzo = "<p class=\"mb-0\"><i class=\"fas fa-weight-hanging mr-2\"></i>Da {$fasciaPrezzo["pesoMinimo"]} kg a {$fasciaPrezzo["pesoMassimo"]} kg | <em><strong>{$fasciaPrezzo["costo"]} €</strong></em></p>";
                echo"<div id=\"fasciaDiPrezzo{$fasciaPrezzo["id"]}\" class=\"col-sm-6 col-lg-4\">
                        <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                $datiFasceDiPrezzo
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaFasciaDiPrezzo({$fasciaPrezzo["id"]},'{$fasciaPrezzo["pesoMinimo"]}','{$fasciaPrezzo["pesoMassimo"]}','{$fasciaPrezzo["costo"]}','{$fasciaPrezzo["costoZoneDisagiate"]}')\"><i class=\"fas fa-edit\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaElemento({$fasciaPrezzo["id"]},'Da {$fasciaPrezzo["pesoMinimo"]} kg a {$fasciaPrezzo["pesoMassimo"]} kg | {$fasciaPrezzo["costo"]} €')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>
                    </div>";
            }
        }
                
        function eliminaFasciaDiPrezzo($idFascia) {
            $this->db->eseguiQueryCancellazione("geecEc_fascePrezzoSpedizione",$idFascia);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getDisponibile() {
            return $this->disponibile;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getCosto() {
            return $this->costo;
        }

        public function getCostoZoneDisagiate() {
            return $this->costoZoneDisagiate;
        }

        public function getImportoMinimoCarrello() {
            return $this->importoMinimoCarrello;
        }
        
        public function getGiorniNecessari() {
            return $this->giorniNecessari;
        }

        public function getGiorniInCuiSiSpedisce() {
            return $this->giorniInCuiSiSpedisce;
        }
        
        public function getOrarioLimite() {
            return $this->orarioLimite;
        }

        public function getAreaGeografica() {
            return $this->areaGeografica;
        }

        public function getDataCreazione() {
            return $this->dataCreazione;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setDisponibile($disponibile): void {
            $this->disponibile = $disponibile;
        }

        public function setCategoria($categoria): void {
            $this->categoria = $categoria;
        }

        public function setDescrizione($descrizione): void {
            $this->descrizione = $descrizione;
        }

        public function setCosto($costo): void {
            $this->costo = $costo;
        }

        public function setCostoZoneDisagiate($costoZoneDisagiate): void {
            $this->costoZoneDisagiate = $costoZoneDisagiate;
        }

        public function setImportoMinimoCarrello($importoMinimoCarrello): void {
            $this->importoMinimoCarrello = $importoMinimoCarrello;
        }

        public function setGiorniNecessari($giorniNecessari): void {
            $this->giorniNecessari = $giorniNecessari;
        }

        public function setGiorniInCuiSiSpedisce($giorniInCuiSiSpedisce): void {
            $this->giorniInCuiSiSpedisce = $giorniInCuiSiSpedisce;
        }
        
        public function setOrarioLimite($orarioLimite): void {
            $this->orarioLimite = $orarioLimite;
        }
        
        public function setAreaGeografica($areaGeografica): void {
            $this->areaGeografica = $areaGeografica;
        }
        
        public function setDataCreazione($dataCreazione): void {
            $this->dataCreazione = $dataCreazione;
        }
    }